package main

import (
	"flag"
	"fmt"
	"os"
  "math"
  "./rdoc"
)

var VERSION="0-1.1"
type Polumost_invertor struct {
    /* параметры транзистора */
	rbe       float64
	rbc       float64
	cbc       float64
  ic_max    float64
  ib_max    float64
  uc_max    float64
  ub_max    float64
  uce_nas   float64 
  ube_nas   float64
  h21e      float64

/* параметры трансфоматора */
	b_gauss   float64
	f_Hz      float64
	a_sm2     float64
	u         float64
	u1        float64
	i1        float64
	n1        float64
	d1        float64
	uu        float64
	iu        float64
	nu        float64
	du        float64
	u2        float64
	i2        float64
	n2        float64
	d2        float64
	u3        float64
	i3        float64
	n3        float64
	d3        float64
	p_full    float64
	p_out     float64
}
func ( p *Polumost_invertor ) invertor() float64 {
    p.rbe = ( p.uu - p.ub_max )/( p.ic_max / p.h21e )
    ube := p.ube_nas / 2
    ibe := ube / p.rbe
    ubc := p.u / 2 - ube
    p.rbc =  ubc / ibe  
    p.cbc = 1 / ( p.rbe * p.f_Hz*2 ) * 1000000000
    fmt.Println( p.rbe, "Ом -- сопротивление база-эмиттер ( R2, R3 )" )
    fmt.Println( p.rbc, "Ом -- сопротивление база-коллектор ( R1, R4 )" )
    fmt.Println( p.cbc, "нФ -- емкость конденсатора база-коллектор ( С1 ), не более" )
    return p.rbe
}
func ( p *Polumost_invertor ) power() float64 {
    p2 := p.u2*p.i2
    p3 := p.u3*p.i3
    p.p_out = p2+p3
    p.p_full = p.p_out/0.8
    p.u1 = p.u / 2 - p.uce_nas
    p.i1 = p.p_full/p.u1
    fmt.Println( p2, "Вт -- мощность вторичной обмотки" )
    fmt.Println( p3, "Вт -- мощность третичной обмотки" )
    fmt.Println( p.p_full, "Вт -- мощность трансформатора" )
    fmt.Println( p.u1, "В -- напряжение первичной обмотки" )
    fmt.Println( p.i1, "А -- ток первичной обмотки" )
    return p.p_full
}

func ( p *Polumost_invertor ) formator() float64 {
    p.n1 = ( p.u1 * 100000000 )/( 4 *  p.a_sm2 * p.b_gauss * p.f_Hz )
    nwv := p.n1 / p.u1
    p.n2 = p.u2 * nwv * 1.05
    p.n3 = p.u3 * nwv * 1.1
    p.uu = p.ub_max * 2
    p.nu = p.uu * nwv
    p.iu = p.ic_max / p.h21e
    p.d1 = p.i1 * 0.44
    p.d2 = p.i2 * 0.35
    p.d3 = p.i3 * 0.35
    p.du = p.iu * 0.5
    fmt.Println( p.uu, "В -- напряжение управляющей обмотки" )
    fmt.Println( p.iu, "А -- ток управляющей обмотки" )
    fmt.Println( " ----------------------------" )
    fmt.Println( " число витков  обмоток:" )
    fmt.Println( " упр.=", p.nu )
    fmt.Println( " I   =", p.n1 )
    fmt.Println( " II  =", p.n2 )
    fmt.Println( " III =", p.n3 )
    fmt.Println( " ----------------------------" )
    fmt.Println( " диаметр проводов обмоток, мм:" )
    fmt.Println( " упр.=", p.du )
    fmt.Println( " I   =", p.d1 )
    fmt.Println( " II  =", p.d2 )
    fmt.Println( " III =", p.d3 )
    fmt.Println(  " ---------------------------" )
    fmt.Println( " длина проводов обмоток ( ориентировочная ), м :" )
    fmt.Println( " упр.=", p.nu * ( math.Sqrt( p.a_sm2 ) + 0.2 ) * 4 / 100 )
    fmt.Println( " I   =", p.n1 * ( math.Sqrt( p.a_sm2 ) + 0.2 ) * 4 / 100 )
    fmt.Println( " II  =", p.n2 * ( math.Sqrt( p.a_sm2 ) + 0.4 ) * 4 / 100 )
    fmt.Println( " III =", p.n3 * ( math.Sqrt( p.a_sm2 ) + 0.5 ) * 4 / 100 )
    return p.p_full
}

var  p=new( Polumost_invertor )

func main() {
  fb  := flag.Float64("b", 3800, "индукция насыщения сердечника, Гаусс")
  ff  := flag.Float64("f", 1000000, "частота, Гц")
  fa  := flag.Float64("a", 0.5625,"сечение сердечника, см2")
  fu  := flag.Float64("u", 15, "напряжение питания, В")
  fu2 := flag.Float64("u2", 6.3, "напряжение вторичной обмотки, В")
  fu3 := flag.Float64("u3", 180, "напряжение третичной обмотки, В")
  fi2 := flag.Float64("i2", 0.7, "ток вторичной обмотки, А")
  fi3 := flag.Float64("i3", 0.04, "ток третичной обмотки, А")
  fh21:= flag.Float64("h21e", 60, "коэффициент усиления транзистора")
  fuce:= flag.Float64("uce", 0.5, "напряжение насыщения коллектор-эмиттер, В")
  fube:= flag.Float64("ube", 2.0, "напряжение насыщения база-эмиттер, В")
  fucm:= flag.Float64("ucm", 30, "напряжение коллектор-эмиттер максимальное, В")
  fubm:= flag.Float64("ubm", 5, "напряжение база-эмиттер максимальное, В")
  ficm:= flag.Float64("icm", 3, "ток коллектора максимальный, А")
  fibm:= flag.Float64("ibm", 1, "ток базы максимальный, А")
  fdoc := flag.String("doc", "", "информация")
	flag.Parse()
  if (*fdoc=="?"||*fdoc=="т"){
      fmt.Println(rdoc.View())
      os.Exit(0)
  }
	p.b_gauss= *fb
	p.f_Hz  = *ff
	p.a_sm2 = *fa
	p.u    = *fu
	p.u2    = *fu2
	p.u3    = *fu3
	p.i2    = *fi2
	p.i3    = *fi3
	p.h21e  = *fh21
	p.uce_nas= *fuce
	p.ube_nas= *fube
	p.uc_max= *fucm
	p.ub_max= *fubm
  p.ic_max= *ficm
  p.ib_max= *fibm
  fmt.Println()
  fmt.Println( "version",VERSION )
  fmt.Println( "-doc ?","получение справки  " )
  fmt.Println( flag.Args() )
  fmt.Println( "Входные данные:" )
  fmt.Println( )
	fmt.Println( "  ",p.b_gauss,  "индукция насыщения сердечника, Гаусс" )
	fmt.Println( "  ",p.f_Hz, "частота, Гц")
	fmt.Println( "  ",p.a_sm2,"сечение сердечника, см2" )
	fmt.Println( "  ",p.u, "напряжение питания, В" )
	fmt.Println( "  ",p.u2,  "напряжение вторичной обмотки, В" )
  fmt.Println( "  ",p.u3, "напряжение третичной обмотки, В" )
	fmt.Println( "  ",p.i2, "ток вторичной обмотки, А" )
	fmt.Println( "  ",p.i3, "ток третичной обмотки, А" )
	fmt.Println( "  ",p.h21e,  "коэффициент усиления транзистора" )
	fmt.Println( "  ",p.uce_nas,  "напряжение насыщения коллектор-эмиттер, В" )
	fmt.Println( "  ",p.ube_nas,  "напряжение насыщения база-эмиттер, В" )
  fmt.Println( "  ",p.uc_max,  "напряжение коллектор-эмиттер максимальное, В" )
	fmt.Println( "  ",p.ub_max,  "напряжение база-эмиттер максимальное, В" )
	fmt.Println( "  ",p.ic_max,  "ток коллектора максимальный, A" )
	fmt.Println( "  ",p.ib_max,  "ток базы максимальный, А" )
  fmt.Println( )
  fmt.Println( "Выходные данные трансформатора:" )
  p.power()
  if( p.uc_max < p.u ) {
      fmt.Println("  !!! max напряжение транзистора < питания: ", p.u)
      os.Exit(0)
  }
  if( p.ic_max < p.i1 ) {
      fmt.Println("  !!! max ток коллектора < тока первичной обмотки: ", p.i1)
      os.Exit(0)
  }
  p.formator()
  fmt.Println( )
  fmt.Println( "Выходные данные инвертора:" )
  p.invertor()
  fmt.Println( )
  fmt.Println( "30й -- расчет окончен ")
  fmt.Println( )
}
