#include <stdio.h>
#include <math.h>
#include "lampout1trans.h"
WyhTrans::WyhTrans()
{
   //const float pi=3.14;
    nu=0.85; // КПД трансформатора
    Ri=30000; // внутреннее сопротивление лампы, Ом
    Ra=5200; // сопротивление нагрузки на аноде, Ом
    r1;     // активное сопротивление первичной обмотки, Ом
    I0=0.048; // ток покоя каскада, А
    Rn=3.5;   //сопротивление нагрузки, Ом
    F_low=30; // частота среза снизу, Гц
    A=0.4;  // коэф. распределения между обмотками
    level=-3; // уровень среза по частоте: -1 или -3
    a=1.6; // ширина средней части пластин Ш, см
    c=1.6;  //ширина окна
    h=4.0; // высота окна
    b=3.2;  // толшина набора
    lc;   // средняя длина магнитной силовой линии
    lo;   // расчетная средняя длина витка
    is_hot_steel=true; // горячекатанная сталь
    Ks=0.9; // коэф.заполнения сердечника железом
    Kok=0.3;// коэф.заполнения окна медью
    mu=250;

    raschet0();
}

WyhTrans::~WyhTrans()
{

}

int WyhTrans::raschet()
{
    printf("\nНачало расчета...\n");
    raschet0();
    printf("\tРасчетная индуктивность первичной обмотки L1= %.2f Гн \n", L1);
    int steps =10;
    float mu_new;
    for(int i=0;i<steps;i++)
    {
        N1=sqrt(7.79e7*L1*lc/(mu*Sc));
        aw0=N1*I0/lc;
        printf("\tпопытка %d : N1=%d, aw0=%.1f, mu=%d \n",i+1,N1,aw0,mu);
        mu_new=is_hot_steel?(2000.0/(aw0+5)+70+0.5):(1600.0/(aw0+3)+120+0.5);
        if ((int)mu_new==mu)
        {
            printf("\t\taлгоритм сошелся...\n");
            break;
        }
        mu=mu_new;
    }
    /* расчетная проверка npuмeHuмocти даНН020 железа */
    tau_el=L1/r1;
    tau_konstr=0.00718*mu*Sc*So*Kok/(lo*lc);
    printf("\ttau_el = %.3f,\ttau_konstr = %.3f\n",tau_el,tau_konstr);
    printf("\t\tжелезо %s\n",((tau_konstr>=tau_el)?"подходит...":"маловато!\n"));
    if (tau_konstr<tau_el) return 1;    
    /* коэффициент трансформации */
    n2=Rn/(Ra*nu);
    /* активное сопротивление вторичной обмотки */
    r2=r1*n2*(1.0-A)/A;
    printf("\tr1 = %.2f Ом,\tr2 = %.2f Ом\n",r1,r2);
    N2=sqrt(n2)*N1;
    printf("\tN1 = %d ,\tN2 = %d \n",N1,N2);
    /* расчитываем диаметры проводов */
    d1=sqrt(2.23e-4*lo*N1/r1);
    d2=sqrt(2.23e-4*lo*N2/r2);
    printf("\td1 = %.2f мм,\td2 = %.2f мм\n",d1,d2);
    float l1,l2;
    l1=N1*lo/100;
    l2=N2*lo/100;
    printf("\tl1(d1) = %.2f м\tl2(d2) = %.2f м\n",l1,l2);
    delta=9.0e-4*N1*I0;
    printf("\tЗазор при сборке сердечника : %.2f мм\n",delta);
    /* рассчитываем заполнение окна */
    Kok=(d1*d1/4*pi*N1+d2*d2/4*pi*N2)*(1e-2)/So;
    printf("\tКоэффициент заполнения окна медью : %.2f\n\n",Kok);

    return 0;
}

int WyhTrans::raschet0()
{
    r1=(1-nu)*Ra;
    lc=c*2+a*1.75+h*2;
    Sc=a*b*Ks;
    So=c*h;
    R_equiv=(Ra+r1)*(Ra-r1)/(Ra+Ri);
    printf("\n R_equiv= %.3f \n",R_equiv);
    lo=2*(a+b)+2.9*c; // расчетная средняя длина витка
    L1=R_equiv/(2*pi*F_low);
    if(level==-1){L1*=2;}
    return 0;
}

int WyhTrans::print_data()
{
    printf("\nИсходные данные: \n");
    printf("\nПараметры выходного каскада : \n");
    printf("\tBнутреннеe сопротивление источника сигнала (лампы) Ri = %.1f Ом\n",Ri);
    printf("\tСопротивление нагрузки в аноде Ra = %.1f Ом\n",Ra);
    printf("\tToк покоя каскада I0 = %.3f А \n", I0);
    printf("\tСопротивление нагрузки трансформатора Rn = %.1f Ом\n",Rn);
    printf("\tАктивное сопротивление первичной обмотки r1 = %.1f Ом\n",r1); 
    printf("\tКоэффициент распределения активного сопротивления между");
    printf("\n\t\tпервичной и вторичной обмотками A = %.2f\n", A);
    printf("\tЧастота среза снизу по уровню %d дБ F_low = %.1f Гц\n",level,F_low);
    printf("\nПараметры сердечника трансформатора: \n");
    printf("\tis_hot_steel = %s\n",((is_hot_steel)?"true (Сталь горячекатанная)":"false (Сталь холоднокатанная)"));
    printf("\tСердечник : Ш%d (a = %.2f(cм)), толщина набора b = %.2f(см) \n", (int)(a*10),a,b);
    printf("\tШирина и высота окна соответственно c = %.2f(см) и h = %.2f(см)\n",c, h);
    printf("\tСредняя длина магнитной силовой лuнuu : %.1f см\n", lc);
    printf("\tCредняя длина витка : %.1f см\n", lo);


    return 0;
}

